/*-----------------------------------------------------------------------------
	[CriticalSection.h]
		Define things needed for critical section.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
-----------------------------------------------------------------------------*/
#ifndef CRITICAL_SECTION_H_INCLUDED
#define CRITICAL_SECTION_H_INCLUDED


#include "TypeDefs.h"


#define CS_MAX		256


/*-----------------------------------------------------------------------------
	Function Prototypes
-----------------------------------------------------------------------------*/
BOOL
CS_Init();


BOOL
CS_Deinit();


Sint32
CS_Create();


BOOL
CS_Delete(
	const Sint32		id);


BOOL
CS_Enter(
	const Sint32		id);


BOOL
CS_Leave(
	const Sint32		id);

#endif		/* CRITICAL_SECTION_H_INCLUDED */
